import {createSelector} from 'reselect';

import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

import {
    IPassengerWithTickets,
    getPassengerWithTicketsListByGenericOrderServices,
} from 'projects/trains/lib/order/getPassengerWithTicketsListByGenericOrderServices';

const trainsOrderPassengersByGenericServicesSelector = createSelector(
    [trainServicesSelector],
    (services): IPassengerWithTickets[] => {
        return getPassengerWithTicketsListByGenericOrderServices(services);
    },
);

export default trainsOrderPassengersByGenericServicesSelector;
