import {createSelector} from 'reselect';

import {TAllSegments} from 'projects/trains/components/TrainsOrderSegments/types';

import {trainsOrderSelector} from 'selectors/account/order/trains/trainsOrderSelector';
import {IOrderTripInfo} from 'selectors/trains/order/orderTripInfoSelector';

import {getOrderSegmentsByGenericOrderServices} from 'projects/trains/lib/order/getOrderSegmentsByGenericOrderServices';
import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';
import {getOrderTripInfoByGenericOrderServices} from 'projects/trains/lib/order/getOrderTripInfoByGenericOrderServices';

const trainsOrderSegmentsInfoByGenericServicesSelector = createSelector(
    [trainsOrderSelector],
    (
        order,
    ): {
        segments: TAllSegments;
        tripInfo: IOrderTripInfo | null;
    } => {
        const trainServices = getTrainServices(order);

        return {
            segments: getOrderSegmentsByGenericOrderServices(trainServices),
            tripInfo: getOrderTripInfoByGenericOrderServices(trainServices),
        };
    },
);

export default trainsOrderSegmentsInfoByGenericServicesSelector;
