import {createSelector} from 'reselect';

import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

import {StoreInterface} from 'reducers/storeTypes';
import {IOrdersState} from 'reducers/account/orders/reducer';

import {checkOrderAccess} from 'projects/account/utilities/order/checkOrderAccess';

import {getOrderAuthorization} from '../common/checkOrderAuthorizationSelector';

export const ordersSelector = (state: StoreInterface): IOrdersState =>
    state.account.orders;

const getOrderId = (
    state: StoreInterface,
    props?: {orderId: string},
): string => {
    return props ? props.orderId : '';
};

export const trainsOrderTypeSelector = (
    state: StoreInterface,
): IOrdersState['trainsOrderType'] => state.account.orders.trainsOrderType;

export const orderIsFetchingSelector = createSelector(
    ordersSelector,
    ({isFetching, trainsOrder, trainsOrderType}): boolean => {
        const defineOrder = (order: IGenericOrderInfo | null): boolean =>
            order
                ? trainsOrderType === ORDER_TYPE_VALUES.TRAINS ||
                  trainsOrderType === ORDER_TYPE_VALUES.TRAINS_GENERIC
                : false;

        if (defineOrder(trainsOrder)) {
            return isFetching;
        }

        return true;
    },
);

export const orderDetailsSelector = createSelector(
    ordersSelector,
    (state: StoreInterface) => state.account.orders.error,
    (state: StoreInterface) => getOrderAuthorization(state),
    (state: StoreInterface, store: {orderId: string}) =>
        getOrderId(state, store),
    ({isError, isAuthError}, error, orderAuthorization, id: string) => {
        const {
            checkAuthorization,
            checkAuthorization: {orderIds},
        } = orderAuthorization;

        return {
            orderType: orderIds?.orderType || null,
            isError: isError,
            isAuthError,
            error,
            isNotFound: !orderIds?.yandexOrderId && checkAuthorization.isError,
            hasAccess: checkOrderAccess(id, orderAuthorization),
            needAuth:
                checkAuthorization.isError &&
                Boolean(orderIds?.yandexOrderId) &&
                orderIds?.id === id,
        };
    },
);
