import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import {currenciesSelector} from 'selectors/common/currenciesSelector';
import featuresSelector from 'selectors/common/featuresSelector';
import environmentConfigSelector from 'selectors/common/environmentConfigSelector';
import {getUserInfo} from 'selectors/common/userInfoSelector';
import {aviaPlatformSelector} from 'selectors/avia/platform/aviaPlatformSelector';
import isYandexoidSelector from 'selectors/common/isYandexoid';
import {isFromXredirectSelector} from 'selectors/common/isFromXredirectSelector';
import experimentsSelector from 'selectors/common/experimentsSelector';
import {whiteLabelConfigSelector} from 'selectors/common/whiteLabelConfigSelector';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    deviceType: deviceTypeSelector,
    currencies: currenciesSelector,
    features: featuresSelector,
    environmentConfig: environmentConfigSelector,
    userIsAuth: state => isAuthUser(getUserInfo(state)),
    userHasPlusInfo: state => Boolean(getUserInfo(state).plusInfo),
    userHasPlus: state => getUserInfo(state).plusInfo?.hasPlus,
    subscribeStatusFetched: state =>
        Boolean(state.common.subscription.status.isFetched),
    needToShowBug: isYandexoidSelector,
    platform: aviaPlatformSelector,
    isFromXredirect: isFromXredirectSelector,
    experiments: experimentsSelector,
    whiteLabelConfig: whiteLabelConfigSelector,
});
