import {StoreInterface} from 'reducers/storeTypes';

import {getAviaState} from './aviaSelectors';

export function getAviaBookingState(state: StoreInterface) {
    return getAviaState(state).aviaBooking;
}

export function getAviaBookingOrders(state: StoreInterface) {
    return getAviaBookingState(state).orders;
}

export function getAviaBookingVariants(state: StoreInterface) {
    return getAviaBookingState(state).variants;
}

export function getAviaBookingCompositeStates(state: StoreInterface) {
    return getAviaBookingState(state).compositeStates;
}

export function getAviaBookingOrder(state: StoreInterface, orderId: string) {
    return getAviaBookingOrders(state)[orderId];
}

export function getAviaBookingVariant(
    state: StoreInterface,
    variantToken: string,
) {
    return getAviaBookingVariants(state)[variantToken];
}

export function getAviaBookingCompositeState(
    state: StoreInterface,
    orderId: string,
) {
    return getAviaBookingCompositeStates(state)[orderId];
}

export function getAviaTravellerNotebook(state: StoreInterface) {
    return getAviaBookingState(state).travellerNotebook;
}

export function getCreateOrderState(state: StoreInterface) {
    return getAviaBookingState(state).createOrder;
}

export function getOrderPaymentStatus(state: StoreInterface) {
    return getAviaBookingState(state).orderPayment;
}
