import {createSelector} from 'reselect';

import {getAviaContext} from 'selectors/avia/aviaSelectors';

const aviaPassengersCountSelector = createSelector(
    getAviaContext,
    context =>
        Number(context.adult_seats) +
        Number(context.children_seats) +
        Number(context.infant_seats),
);

export const isOnlyOnePassengerSelector = createSelector(
    aviaPassengersCountSelector,
    passengers => passengers === 1,
);

export default aviaPassengersCountSelector;
