import {createSelector} from 'reselect';

import {getAviaContext} from 'selectors/avia/aviaSelectors';
import getKlassTypeText from 'selectors/avia/utils/getKlassTypeText';

import {formatDateRange} from 'utilities/dateUtils';

import * as i18nBlock from 'i18n/avia';
import * as i18nTrainsSearchInformationBlock from 'i18n/trains-search-information';

export default createSelector(getAviaContext, context => {
    const {from, to, klass, when} = context;
    const passengersCount =
        Number(context.adult_seats) +
        Number(context.children_seats) +
        Number(context.infant_seats);
    const classType = klass && getKlassTypeText(klass);

    return {
        from:
            (from && from.title) ||
            i18nTrainsSearchInformationBlock.fromDashPlaceholder(),
        to:
            (to && to.title) ||
            i18nTrainsSearchInformationBlock.toDashPlaceholder(),
        when: when
            ? formatDateRange(when, context.return_date)
            : i18nTrainsSearchInformationBlock.periodDashPlaceholder(),
        classType: classType && classType.toLowerCase(),
        passengers: passengersCount
            ? i18nBlock.componentsDotAviaTravellersDotTravellers({
                  count: passengersCount,
              })
            : '',
    };
});
