import {createSelector} from 'reselect';

import {TCalendarPrices} from 'types/common/calendarPrice/ICalendarPrice';

import {StoreInterface} from 'reducers/storeTypes';
import {IAviaStore} from 'reducers/avia/IAviaStore';

export const getAviaState = (state: StoreInterface): IAviaStore => state.avia;

export const getAviaCalendarPricesState = (
    state: StoreInterface,
): IAviaStore['aviaCalendarPrices'] => getAviaState(state).aviaCalendarPrices;

export const getAviaCalendarPrices = (state: StoreInterface): TCalendarPrices =>
    getAviaCalendarPricesState(state).prices;

export const getAviaPointsData = (
    state: StoreInterface,
): IAviaStore['aviaPointsData'] => getAviaState(state).aviaPointsData;

export const getAviaContext = (
    state: StoreInterface,
): IAviaStore['aviaContext'] => getAviaState(state).aviaContext;

export const getAviaFeaturesFlags = (
    state: StoreInterface,
): IAviaStore['aviaFeaturesFlags'] => getAviaState(state).aviaFeaturesFlags;

export const getAviaLogMetrics = (
    state: StoreInterface,
): IAviaStore['aviaLogMetrics'] => getAviaState(state).aviaLogMetrics;

export const getAviaRoute = (state: StoreInterface): IAviaStore['aviaRoute'] =>
    getAviaState(state).aviaRoute;

export const getAviaFlightsTo = (
    state: StoreInterface,
): IAviaStore['aviaFlightsTo'] => getAviaState(state).aviaFlightsTo;

export const getAviaCountryRestrictions = (
    state: StoreInterface,
): IAviaStore['countryRestrictions'] => getAviaState(state).countryRestrictions;

export const useOrderDataSelector = (state: StoreInterface): boolean =>
    getAviaState(state).aviaOrder.useOrderData;

export const qidSelector = createSelector(
    useOrderDataSelector,
    (state: StoreInterface) => state.avia.aviaOrder.qid,
    (state: StoreInterface) => state.avia.aviaSearch.results.qid,
    (useOrderData, orderQid, searchQid) =>
        useOrderData ? orderQid : searchQid,
);
