/* eslint-disable camelcase */
import {createSelector} from 'reselect';
import mapValues from 'lodash/mapValues';

import {getAviaBookingVariants} from 'selectors/avia/aviaBooking';

import IPrice from 'utilities/currency/PriceInterface';
import {areEqualPrices} from 'utilities/currency/areEqualPrices';

export const oldPricesSelector = createSelector(
    [getAviaBookingVariants],
    (allVariants): PartialRecord<string, IPrice> => {
        return mapValues(allVariants, ({variants}) => {
            if (!variants) {
                return undefined;
            }

            const {first_check_price, preliminary_price} = variants.priceInfo;

            if (areEqualPrices(first_check_price, preliminary_price)) {
                return undefined;
            }

            return preliminary_price;
        });
    },
);
