import {createSelector} from 'reselect';

import TDateRobot from 'types/common/date/TDateRobot';

import {getAviaContext} from 'selectors/avia/aviaSelectors';

import isDateRobot from 'utilities/dateUtils/isDateRobot';

interface IAviaContextDates {
    when: TDateRobot;

    returnDate?: TDateRobot;
}

export const aviaContextDatesSelector = createSelector(
    getAviaContext,
    // eslint-disable-next-line camelcase
    ({when, return_date}): IAviaContextDates | undefined => {
        if (!isDateRobot(when)) {
            return undefined;
        }

        // eslint-disable-next-line camelcase
        const returnDate = isDateRobot(return_date) ? return_date : undefined;

        return {
            when,
            returnDate,
        };
    },
);
