import {createSelector} from 'reselect';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

import {getAviaContext} from 'selectors/avia/aviaSelectors';

import {getSearchFormFromContext} from 'projects/avia/lib/search/getSearchFormFromContext';

export const aviaContextSearchFormSelector = createSelector(
    getAviaContext,
    (aviaContext): IAviaParams => getSearchFormFromContext(aviaContext),
);
