import {createSelector} from 'reselect';

import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import {
    aviaDynamicsPricesForFiltersSelector,
    aviaDynamicsPricesForSearchFormSelector,
    aviaDynamicsPricesIntervalSelector,
} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesSelectors';

/**
 * Возвращает данные о том с какими данными производился/производится запрос к динамике
 */
const aviaDynamicsPricesCurrentRequestParamsSelector = createSelector(
    aviaDynamicsPricesForSearchFormSelector,
    aviaDynamicsPricesForFiltersSelector,
    aviaDynamicsPricesIntervalSelector,
    (searchForm, filters, interval): TValidDataForRequestDynamic | null => {
        if (!searchForm || !filters || !interval) {
            return null;
        }

        return {
            searchForm,
            filters,
            interval,
        };
    },
);

export default aviaDynamicsPricesCurrentRequestParamsSelector;
