import {createSelector} from 'reselect';

import {EDynamicsDayStatus} from 'projects/avia/components/Dynamics/types/IDynamicsDay';

import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {aviaDynamicsPricesPriceSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesSelectors';
import {getAviaMinSearchPrice} from 'selectors/avia/search/getMinSearchPrice';
import {getAviaSearchFilters} from 'selectors/avia/search/aviaSearchResultsSelector';
import {aviaContextSearchFormSelector} from 'selectors/avia/context/aviaContextSearchFormSelector';
import aviaDynamicsPricesCurrentRequestParamsSelector from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesCurrentRequestParamsSelector';

import isDateRobot from 'utilities/dateUtils/isDateRobot';
import isCompatibleSearchForm from 'projects/avia/lib/dynamic/isCompatibleSearchForm';
import isSameSearchFilters from 'projects/avia/lib/dynamic/isSameSearchFilters';

const DEFAULT_PRICE = {};

/**
 * Если будет возможно, то к ценам динамики будет добавлена актуальная цена с поиска
 */
export const aviaDynamicsPricesFinalPriceSelector = createSelector(
    aviaDynamicsPricesPriceSelector,
    aviaDynamicsPricesCurrentRequestParamsSelector,
    getAviaMinSearchPrice,
    getAviaSearchFilters,
    aviaContextSearchFormSelector,
    (
        prices,
        currentRequestParams,
        minSearchPrice,
        searchFilters,
        searchForm,
    ): TDynamicsDaysInfo => {
        const {when} = searchForm;

        if (
            minSearchPrice &&
            isDateRobot(when) &&
            currentRequestParams &&
            isCompatibleSearchForm(
                searchForm,
                currentRequestParams.searchForm,
            ) &&
            isSameSearchFilters(searchFilters, currentRequestParams.filters)
        ) {
            return {
                ...prices,
                [when]: {
                    status: EDynamicsDayStatus.HAS_DATA,
                    price: {
                        ...minSearchPrice,
                        roughly: false,
                    },
                    progress: 100,
                    fromSearch: true,
                },
            };
        }

        return prices || DEFAULT_PRICE;
    },
);
