import {createSelector} from 'reselect';
import moment from 'moment';

import TDateRobot from 'types/common/date/TDateRobot';

import {aviaDynamicsPricesSearchFormSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesSearchFormSelector';

import isDateRobot from 'utilities/dateUtils/isDateRobot';
import getDateRobotFromMoment from 'utilities/dateUtils/getDateRobotFromMoment';

/**
 * Дата поиска туда
 */
const aviaDynamicsPricesForwardDateSelector = createSelector(
    aviaDynamicsPricesSearchFormSelector,
    ({when}): TDateRobot => {
        return isDateRobot(when) ? when : getDateRobotFromMoment(moment(when));
    },
);

export default aviaDynamicsPricesForwardDateSelector;
