import {createSelector} from 'reselect';

import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';

import {aviaDynamicsPricesSearchFormSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesSearchFormSelector';
import {aviaDynamicsPricesFiltersSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesFiltersSelector';

import isDateRobot from 'utilities/dateUtils/isDateRobot';

/**
 * Возвращает данные для запроса динамики цен за исключением интервала.
 *
 * Вернет null, если данные отсутствуют.
 */
export const aviaDynamicsPricesRequestParamsSelector = createSelector(
    aviaDynamicsPricesFiltersSelector,
    aviaDynamicsPricesSearchFormSelector,
    (filters, searchForm): Omit<IDataForRequestDynamic, 'interval'> | null => {
        const {when} = searchForm;

        if (!isDateRobot(when)) {
            return null;
        }

        return {
            filters,
            searchForm,
        };
    },
);
