import {StoreInterface} from 'reducers/storeTypes';
import {IAviaDynamicsState} from 'reducers/avia/aviaPriceIndex/dynamics/reducer';
import {IAviaContext} from 'reducers/avia/data-types';

/**
 * Возвращает весь стор динамики цен
 */
const aviaDynamicsPricesSelector = (
    state: StoreInterface,
): IAviaDynamicsState => state.avia.aviaPriceIndex.dynamicsPrices;

/**
 * Возвращает собственный контекст поиска динамики
 */
export const aviaDynamicsPricesContextSelector = (
    state: StoreInterface,
): IAviaContext => aviaDynamicsPricesSelector(state).searchForm;

/**
 * Возвращает цены
 */
export const aviaDynamicsPricesPriceSelector = (
    state: StoreInterface,
): IAviaDynamicsState['prices'] => aviaDynamicsPricesSelector(state).prices;

/**
 * Возвращает признак того, что динамика была открыта на конкретной выдаче
 */
export const aviaDynamicsPricesWasOpenedSelector = (
    state: StoreInterface,
): IAviaDynamicsState['wasOpened'] =>
    aviaDynamicsPricesSelector(state).wasOpened;

/**
 * Возвращает статус запроса за данными динамики
 */
export const aviaDynamicsPricesStatusSelector = (
    state: StoreInterface,
): IAviaDynamicsState['status'] => aviaDynamicsPricesSelector(state).status;

/**
 * Возвращает ошибку запроса
 */
export const aviaDynamicsPricesErrorSelector = (
    state: StoreInterface,
): IAviaDynamicsState['error'] => aviaDynamicsPricesSelector(state).error;

/**
 * Возвращает интервал для которого производился/производится запрос за данными
 */
export const aviaDynamicsPricesIntervalSelector = (
    state: StoreInterface,
): IAviaDynamicsState['forInterval'] =>
    aviaDynamicsPricesSelector(state).forInterval;

/**
 * Возвращает данные поисковой формы для которой производился/производится запрос за данными
 */
export const aviaDynamicsPricesForSearchFormSelector = (
    state: StoreInterface,
): IAviaDynamicsState['forSearchForm'] =>
    aviaDynamicsPricesSelector(state).forSearchForm;

/**
 * Возвращает фильтры для которых производился/производится запрос за данными
 */
export const aviaDynamicsPricesForFiltersSelector = (
    state: StoreInterface,
): IAviaDynamicsState['forFilters'] =>
    aviaDynamicsPricesSelector(state).forFilters;

/**
 * Тип отображения (таблица/график)
 */
export const aviaDynamicsPricesTypeViewSelector = (
    state: StoreInterface,
): IAviaDynamicsState['typeView'] => aviaDynamicsPricesSelector(state).typeView;
