import {createSelector} from 'reselect';

import {aviaFiltersStateSelector} from 'selectors/avia/search/filters/activeFilters';

type TDynamicsExcludedFilters = ['partners'];

/**
 * Фильтры, которые не поддерживаются на стороне бекенда в ручке priceIndex.
 * Соответственно при выборе этих фильтров на выдаче мы будем показывать неверные цены
 * в динамике цен и лучше не давать подсказки вроде "на соседние даты цены дешевле"
 */
const DYNAMIC_EXCLUDED_FILTERS: TDynamicsExcludedFilters = ['partners'];

export const getHasAviaDynamicsExcludedFilters = createSelector(
    aviaFiltersStateSelector,
    filtersState =>
        DYNAMIC_EXCLUDED_FILTERS.some(filterName => filtersState[filterName]),
);
