import {createSelector} from 'reselect';

import {currenciesSelector} from 'selectors/common/currenciesSelector';
import {aviaOrderSelectors} from 'selectors/avia/order/aviaOrderSelector';

export const aviaOrderActionLogData = createSelector(
    aviaOrderSelectors.qid,
    aviaOrderSelectors.baggage,
    aviaOrderSelectors.searchIsComplete,
    aviaOrderSelectors.offers,
    currenciesSelector,
    (qid, baggage, searchIsCompleted, offers, currency) => ({
        qid,
        currency: currency.preferredCurrency,
        baggage,
        searchIsCompleted,
        offers,
    }),
);
