import {createSelector} from 'reselect';

import {DEFAULT_CHILDREN_AGE, DEFAULT_BABY_AGE} from 'constants/hotels';

import {crossSaleHotelsLimitSelector} from 'selectors/common/hotelsCrossSale/crossSaleHotelsLimitSelector';

import {parseAdults} from 'projects/hotels/utilities/validateSearchHotelsParams/validateSearchHotelsParams';

import {ICrossSaleRequestParams} from 'components/SearchHotelsCrossSaleMap/SearchHotelsCrossSaleMap';

import {aviaContextSelector} from '../context/aviaContextSelector';

export const aviaContextForCrossSaleSelector = createSelector(
    aviaContextSelector,
    crossSaleHotelsLimitSelector,
    (context, totalHotelLimit): ICrossSaleRequestParams | null => {
        if (!context.when) {
            return null;
        }

        return {
            pointKey: context.toId,
            totalHotelLimit,
            checkinDate: context.when,
            checkoutDate: context.return_date,
            adults: parseAdults(context.adult_seats),
            childrenAges: Array(Number.parseInt(context.children_seats, 10))
                .fill(DEFAULT_CHILDREN_AGE)
                .concat(
                    Array(Number.parseInt(context.infant_seats, 10)).fill(
                        DEFAULT_BABY_AGE,
                    ),
                ),
        };
    },
);
