import {createSelector} from 'reselect';

import {EAviaActionLogPageName} from 'server/loggers/avia/AviaActionLog/types/EAviaActionLogPageName';
import IAviaDynamicActionLogParams from 'server/loggers/avia/AviaActionLog/types/IAviaDynamicActionLogParams';

import {
    getAviaSearchFilters,
    getAviaSearchResults,
} from 'selectors/avia/search/aviaSearchResultsSelector';
import {currenciesSelector} from 'selectors/common/currenciesSelector';

import prepareSearchSort from 'server/loggers/avia/AviaActionLog/utils/prepareSearchSort';

import getWeekPricesInfo from '../weekPrices/aviaWeekPricesInfo';

export default createSelector(
    getAviaSearchFilters,
    currenciesSelector,
    getAviaSearchResults,
    getWeekPricesInfo,
    (
        filters,
        currencies,
        results,
        weekPricesInfo,
    ): IAviaDynamicActionLogParams => ({
        page: EAviaActionLogPageName.SERP,
        filters,
        currency: currencies.preferredCurrency,
        qid: results.qid,
        sort: prepareSearchSort(results.sorting),
        dynamicPriceType: weekPricesInfo.priceType,
        dynamicPriceDiff: weekPricesInfo.priceDiff,
    }),
);
