import {createSelector} from 'reselect';

import {IAviaSearchActionLogParamsClient} from 'server/loggers/avia/AviaActionLog/types/IAviaActionLogParamsClient';
import {EAviaActionLogPageName} from 'server/loggers/avia/AviaActionLog/types/EAviaActionLogPageName';

import {
    getAviaSearchFilters,
    getAviaSearchResults,
} from 'selectors/avia/search/aviaSearchResultsSelector';
import {currenciesSelector} from 'selectors/common/currenciesSelector';

export const aviaSearchLogSelector = createSelector(
    getAviaSearchFilters,
    currenciesSelector,
    getAviaSearchResults,
    (filters, currencies, results): IAviaSearchActionLogParamsClient => ({
        page: EAviaActionLogPageName.SERP,
        filters,
        currency: currencies.preferredCurrency,
        qid: results.qid,
        sort: results.sorting,
    }),
);
