import {createSelector} from 'reselect';

import {getAviaSearchResults} from 'selectors/avia/search/aviaSearchResultsSelector';

export const aviaSearchResultState = createSelector(
    getAviaSearchResults,
    results => {
        const {
            cont,
            qid,
            sorting,
            filters,
            progress,
            error,
            searchKey,
            searchIsCompleted,
        } = results;

        return {
            cont,
            qid,
            sorting,
            filters,
            progress,
            error,
            searchKey,
            searchIsCompleted,
        };
    },
);
