import {createSelector} from 'reselect';

import {getAviaState} from 'selectors/avia/aviaSelectors';

export const getAviaSearchResults = createSelector(
    getAviaState,
    state => state.aviaSearch.results,
);

export const getAviaSearchReference = createSelector(
    getAviaSearchResults,
    state => state.reference,
);

export const getAviaSearchSorting = createSelector(
    getAviaSearchResults,
    state => state.sorting,
);

export const getAviaSearchFilters = createSelector(
    getAviaSearchResults,
    state => state.filters,
);

export const getAviaSearchVariantsMap = createSelector(
    getAviaSearchResults,
    results => results.variants,
);
