import {createSelector} from 'reselect';

import {aviaAirportsFilterSelector} from 'selectors/avia/search/filters/airportsFilter';
import {aviaBaggageFilterSelector} from 'selectors/avia/search/filters/baggageFilter';
import {aviaCompanyFilterSelector} from 'selectors/avia/search/filters/companyFilter';
import {aviaPartnersFilterSelector} from 'selectors/avia/search/filters/partnersFilter';
import {aviaPriceFilterSelector} from 'selectors/avia/search/filters/priceFilter';
import {aviaTimeFilterSelector} from 'selectors/avia/search/filters/timeFilter';
import {aviaTransferFilterSelector} from 'selectors/avia/search/filters/transferFilter';

export const aviaFiltersStateSelector = createSelector(
    aviaAirportsFilterSelector.directionsIsActive,
    aviaBaggageFilterSelector.isActive,
    aviaCompanyFilterSelector.isActive,
    aviaPartnersFilterSelector.isActive,
    aviaPriceFilterSelector.isActive,
    aviaTimeFilterSelector.isActive,
    aviaTransferFilterSelector.isActive,
    aviaAirportsFilterSelector.transfersIsActive,
    (
        airports,
        baggage,
        company,
        partners,
        price,
        time,
        transferValue,
        transferAirports,
    ) => ({
        airports,
        baggage,
        company,
        partners,
        price,
        time,
        transfer: transferValue || transferAirports,
    }),
);

export const aviaActiveFiltersCountSelector = createSelector(
    aviaFiltersStateSelector,
    filtersState => Object.values(filtersState).filter(Boolean).length,
);

export const aviaMobileDynamicsActiveFiltersCountSelector = createSelector(
    aviaTimeFilterSelector.isActive,
    aviaTransferFilterSelector.isActive,
    (time, transfer) => [time, transfer].filter(Boolean).length,
);
