import {first, last} from 'lodash';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {SegmentStationsMaps} from 'projects/avia/lib/search/getStationMaps';

import {
    AirportsFilterViewData,
    SegmentStationViewState,
    AirportsFilterSettlements,
} from './index';

export function getInitialViewData(
    variants: IResultAviaVariant[],
): AirportsFilterViewData {
    const stations: SegmentStationsMaps[] = [];
    const stationsByTag: Record<string, SegmentStationViewState[]> = {};
    for (let variantIdx = 0; variantIdx < variants.length; variantIdx++) {
        const {tag, route} = variants[variantIdx];
        if (!stationsByTag[tag]) {
            stationsByTag[tag] = [];
        }
        for (let segmentIdx = 0; segmentIdx < route.length; segmentIdx++) {
            if (route[segmentIdx].length === 0) {
                continue;
            }
            let stationsViewState = stationsByTag[tag][segmentIdx];
            if (!stationsViewState) {
                stationsViewState = stationsByTag[tag][segmentIdx] = {
                    arrival: -1,
                    departure: -1,
                    transfers: [],
                };
            }
            let segmentStation = stations[segmentIdx];
            if (!segmentStation) {
                segmentStation = stations[segmentIdx] = {
                    departure: {},
                    arrival: {},
                    transfers: {},
                };
            }
            const segment = route[segmentIdx];
            // Аэропорты вылета
            const fromFlight = first(segment);
            if (fromFlight) {
                stationsViewState.departure = fromFlight.from.id;
                segmentStation.departure[fromFlight.from.id] = fromFlight.from;
            }
            // Аэропорты прибытия
            const toFlight = last(segment);
            if (toFlight) {
                stationsViewState.arrival = toFlight.to.id;
                segmentStation.arrival[toFlight.to.id] = toFlight.to;
            }
            // Аэропорты пересадок
            for (let i = 1; i < segment.length; i++) {
                const flight = segment[i];
                stationsViewState.transfers.push(flight.from.id);
                segmentStation.transfers[flight.from.id] = flight.from;
            }
        }
    }

    const settlements: AirportsFilterSettlements[] = [];
    if (variants[0]) {
        variants[0].route.forEach(segment => {
            if (segment.length === 0) {
                return;
            }
            const from = segment[0].from.settlement;
            const to = segment[segment.length - 1].to.settlement;
            if (from && to) {
                settlements.push({
                    from,
                    to,
                });
            }
        });
    }

    return {
        stations,
        stationsByTag,
        disabledStations: [],
        settlements,
    };
}
