import {IAviaSearchSegmentsAirportsFilter} from 'reducers/avia/search/results/filters/reducer';

import {memoizeOne} from 'utilities/functions/memoizeOne';

import {AirportsFilterViewData} from './index';

export const validateValue = memoizeOne(
    (
        airportsFilter: IAviaSearchSegmentsAirportsFilter[],
        {stations}: AirportsFilterViewData,
    ): IAviaSearchSegmentsAirportsFilter[] => {
        return airportsFilter.map(
            (segmentFilter, idx): IAviaSearchSegmentsAirportsFilter => {
                const segmentStations = stations[idx];

                if (!segmentStations) {
                    return {arrival: [], departure: [], transfers: []};
                }

                return {
                    arrival: segmentFilter.arrival.filter(
                        // eslint-disable-next-line no-eq-null
                        stationId => segmentStations.arrival[stationId] != null,
                    ),
                    departure: segmentFilter.departure.filter(
                        stationId =>
                            // eslint-disable-next-line no-eq-null
                            segmentStations.departure[stationId] != null,
                    ),
                    transfers: segmentFilter.transfers.filter(
                        stationId =>
                            // eslint-disable-next-line no-eq-null
                            segmentStations.transfers[stationId] != null,
                    ),
                };
            },
        );
    },
);
