import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import {getDenormalizedVariants} from 'selectors/avia/search/getDenormalizedVariants';

import IPrice from 'utilities/currency/PriceInterface';
import {aviaFilterBy} from 'projects/avia/lib/search/filters/filterVariants';

export interface BaggageFilterViewData {
    price: IPrice | null;
}

const valueSelector = (state: StoreInterface) =>
    state.avia.aviaSearch.results.filters.baggage;

const filteredSelector = createSelector(
    valueSelector,
    getDenormalizedVariants,
    aviaFilterBy.baggage,
);

const isActiveSelector = createSelector(valueSelector, value => value.enabled);

export const aviaBaggageFilterSelector = {
    key: 'baggage',
    isActive: isActiveSelector,
    filtered: filteredSelector,
    value: valueSelector,
};
