import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {PriceComparator} from 'utilities/currency/compare';

import {BaggageFilterViewData} from './index';

export function aviaUpdateBaggageViewData(
    variants: IResultAviaVariant[],
    filteredByOthers: Record<string, boolean>,
    {min}: PriceComparator,
): BaggageFilterViewData {
    let price = null;

    for (let i = 0; i < variants.length; i++) {
        const variant = variants[i];
        const isFilteredByOthers = Boolean(filteredByOthers[variant.tag]);

        if (!isFilteredByOthers && variant.hasBaggage) {
            price = price
                ? min(variant.price.tariff, price)
                : variant.price.tariff;
        }
    }

    return {
        price,
    };
}
