import {values} from 'lodash';

import {IAlliance} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';
import {IResultCompany} from 'selectors/avia/utils/denormalization/company';
import {
    CompanyFilterViewData,
    TCompaniesByAllienceMap,
} from 'selectors/avia/search/filters/companyFilter/index';

import {getCompanyFromVariant} from 'projects/avia/lib/search/filters/isPassingCompanyFilter';
import IPrice from 'utilities/currency/PriceInterface';
import {compareStrings} from 'projects/avia/lib/comparators/compareStrings';

function sortCompanies(a: IResultCompany, b: IResultCompany) {
    return compareStrings(a.title, b.title);
}

function registerCompany(
    company: IResultCompany,
    allCompaniesMap: Record<number, IResultCompany>,
    allAlliencesMap: Record<number, IAlliance>,
    companiesByAllienceMap: TCompaniesByAllienceMap,
) {
    allCompaniesMap[company.id] = company;

    if (company.alliance) {
        allAlliencesMap[company.alliance.id] = company.alliance;
        companiesByAllienceMap[company.alliance.id] =
            companiesByAllienceMap[company.alliance.id] || {};
        companiesByAllienceMap[company.alliance.id][company.id] = true;
    }
}

export const getInitialViewData = (
    variants: IResultAviaVariant[],
): CompanyFilterViewData => {
    const allCompaniesMap: Record<number, IResultCompany> = {};
    const allAlliencesMap: Record<number, IAlliance> = {};
    const companiesByAllienceMap: TCompaniesByAllienceMap = {};

    const invalidVariantsMap: Record<string, boolean> = {};

    variants.forEach(variant => {
        const company = getCompanyFromVariant(variant);

        // Отбрасываем фейковые компании
        if (company.id !== -1) {
            registerCompany(
                company,
                allCompaniesMap,
                allAlliencesMap,
                companiesByAllienceMap,
            );
        } else {
            invalidVariantsMap[variant.tag] = true;
        }
    });

    return {
        allAlliences: values(allAlliencesMap),
        allCompanies: values(allCompaniesMap).sort(sortCompanies),
        availableCompanies: {} as Record<number, IPrice>,
        availableAlliences: {} as Record<number, boolean>,
        companiesByAllienceMap,
        invalidVariantsMap,
    };
};
