import {createSelector} from 'reselect';

import {IAlliance} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {StoreInterface} from 'reducers/storeTypes';
import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {IResultCompany} from 'selectors/avia/utils/denormalization/company';
import {getDenormalizedVariants} from 'selectors/avia/search/getDenormalizedVariants';
import {getInitialViewData} from 'selectors/avia/search/filters/companyFilter/getInitialViewData';

import IPrice from 'utilities/currency/PriceInterface';
import {aviaFilterBy} from 'projects/avia/lib/search/filters/filterVariants';

export type TCompaniesByAllienceMap = Record<number, Record<number, boolean>>;

export interface CompanyFilterViewData {
    allAlliences: IAlliance[];
    allCompanies: IResultCompany[];
    availableCompanies: Record<number, IPrice>;
    availableAlliences: Record<number, boolean>;
    companiesByAllienceMap: TCompaniesByAllienceMap;
    invalidVariantsMap: Record<string, boolean>;
}

const valueSelector = (
    state: StoreInterface,
): IAviaSearchResultsFilters['company'] =>
    state.avia.aviaSearch.results.filters.company;

const initialViewDataSelector = createSelector(
    getDenormalizedVariants,
    getInitialViewData,
);

const filteredSelector = createSelector(
    valueSelector,
    getDenormalizedVariants,
    aviaFilterBy.company,
);

const isActiveSelector = createSelector(
    valueSelector,
    value => value.companiesIds.length > 0 || value.combinationsAreEnabled,
);

const selectedCountSelector = createSelector(
    valueSelector,
    value => value.companiesIds.length + Number(value.combinationsAreEnabled),
);

export const aviaCompanyFilterSelector = {
    key: 'company',
    isActive: isActiveSelector,
    selectedCount: selectedCountSelector,
    filtered: filteredSelector,
    initialViewData: initialViewDataSelector,
    value: valueSelector,
};
