import {TAviaSearchCompanyFilter} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';
import {CompanyFilterViewData} from 'selectors/avia/search/filters/companyFilter';

import {PriceComparator} from 'utilities/currency/compare';
import {
    getCompanyFromVariant,
    getFilterCompaniesCountFromVariant,
} from 'projects/avia/lib/search/filters/isPassingCompanyFilter';

export const enreachViewData = (
    variant: IResultAviaVariant,
    value: TAviaSearchCompanyFilter,
    viewData: CompanyFilterViewData,
    filteredByOthers: Record<string, boolean>,
    priceComparator: PriceComparator,
) => {
    const {tag, price} = variant;

    if (filteredByOthers[tag] || viewData.invalidVariantsMap[tag]) {
        return;
    }

    const {availableAlliences, availableCompanies} = viewData;
    const filterCompany = getCompanyFromVariant(variant);

    if (
        !value.combinationsAreEnabled &&
        getFilterCompaniesCountFromVariant(variant) > 1
    ) {
        return;
    }

    const curPrice = availableCompanies[filterCompany.id];

    availableCompanies[filterCompany.id] = curPrice
        ? priceComparator.min(curPrice, price.tariff)
        : price.tariff;

    if (filterCompany.alliance) {
        availableAlliences[filterCompany.alliance.id] = true;
    }
};

export const aviaUpdateCompanyViewData = (
    variants: IResultAviaVariant[],
    value: TAviaSearchCompanyFilter,
    viewData: CompanyFilterViewData,
    filteredByOthers: Record<string, boolean>,
    priceComparator: PriceComparator,
) => {
    for (let i = 0; i < variants.length; i++) {
        enreachViewData(
            variants[i],
            value,
            viewData,
            filteredByOthers,
            priceComparator,
        );
    }

    return viewData;
};
