import {createSelector} from 'reselect';

import {aviaAirportsFilterSelector} from 'selectors/avia/search/filters/airportsFilter';
import {aviaBaggageFilterSelector} from 'selectors/avia/search/filters/baggageFilter';
import {aviaCompanyFilterSelector} from 'selectors/avia/search/filters/companyFilter';
import {aviaPartnersFilterSelector} from 'selectors/avia/search/filters/partnersFilter';
import {aviaPriceFilterSelector} from 'selectors/avia/search/filters/priceFilter';
import {aviaTimeFilterSelector} from 'selectors/avia/search/filters/timeFilter';
import {aviaTransferFilterSelector} from 'selectors/avia/search/filters/transferFilter';
import {aviaPlusPointsFilterSelector} from 'selectors/avia/search/filters/plusPointsFilter';

export const aviaFilteredByOthersSelector = {
    airports: createSelector(
        aviaBaggageFilterSelector.filtered,
        aviaCompanyFilterSelector.filtered,
        aviaPartnersFilterSelector.filtered,
        aviaPriceFilterSelector.filtered,
        aviaTimeFilterSelector.filtered,
        aviaTransferFilterSelector.filtered,
        aviaPlusPointsFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
    baggage: createSelector(
        aviaAirportsFilterSelector.filtered,
        aviaCompanyFilterSelector.filtered,
        aviaPartnersFilterSelector.filtered,
        aviaPriceFilterSelector.filtered,
        aviaTimeFilterSelector.filtered,
        aviaTransferFilterSelector.filtered,
        aviaPlusPointsFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
    company: createSelector(
        aviaAirportsFilterSelector.filtered,
        aviaBaggageFilterSelector.filtered,
        aviaPartnersFilterSelector.filtered,
        aviaPriceFilterSelector.filtered,
        aviaTimeFilterSelector.filtered,
        aviaTransferFilterSelector.filtered,
        aviaPlusPointsFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
    partners: createSelector(
        aviaAirportsFilterSelector.filtered,
        aviaBaggageFilterSelector.filtered,
        aviaCompanyFilterSelector.filtered,
        aviaPriceFilterSelector.filtered,
        aviaTimeFilterSelector.filtered,
        aviaTransferFilterSelector.filtered,
        aviaPlusPointsFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
    plusPoints: createSelector(
        aviaAirportsFilterSelector.filtered,
        aviaBaggageFilterSelector.filtered,
        aviaCompanyFilterSelector.filtered,
        aviaPriceFilterSelector.filtered,
        aviaTimeFilterSelector.filtered,
        aviaTransferFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
    price: createSelector(
        aviaAirportsFilterSelector.filtered,
        aviaBaggageFilterSelector.filtered,
        aviaCompanyFilterSelector.filtered,
        aviaPartnersFilterSelector.filtered,
        aviaTimeFilterSelector.filtered,
        aviaTransferFilterSelector.filtered,
        aviaPlusPointsFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
    time: createSelector(
        aviaAirportsFilterSelector.filtered,
        aviaBaggageFilterSelector.filtered,
        aviaCompanyFilterSelector.filtered,
        aviaPartnersFilterSelector.filtered,
        aviaPriceFilterSelector.filtered,
        aviaTransferFilterSelector.filtered,
        aviaPlusPointsFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
    transfer: createSelector(
        aviaAirportsFilterSelector.filtered,
        aviaBaggageFilterSelector.filtered,
        aviaCompanyFilterSelector.filtered,
        aviaPartnersFilterSelector.filtered,
        aviaPriceFilterSelector.filtered,
        aviaTimeFilterSelector.filtered,
        aviaPlusPointsFilterSelector.filtered,
        (...filtered) => Object.assign({}, ...filtered),
    ),
};
