import {createSelector} from 'reselect';

import {getAviaSearchFilters} from 'selectors/avia/search/aviaSearchResultsSelector';

import {filterValuesToHash} from 'projects/avia/lib/search/filters/converters';
import {getAppliedAviaFilters} from 'projects/avia/lib/search/filters/getAppliedFilters';

export const filtersHashSelector = createSelector(
    getAviaSearchFilters,
    filters => filterValuesToHash(getAppliedAviaFilters(filters)),
);
