import {createSelector} from 'reselect';

import {ITDPartner} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {StoreInterface} from 'reducers/storeTypes';
import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {getDenormalizedVariants} from 'selectors/avia/search/getDenormalizedVariants';

import {aviaFilterBy} from 'projects/avia/lib/search/filters/filterVariants';

export interface IPartnersFilterViewData {
    partners: Record<string, ITDPartner>;
    disabledPartners: Record<string, boolean>;
}

const valueSelector = (
    state: StoreInterface,
): IAviaSearchResultsFilters['partners'] =>
    state.avia.aviaSearch.results.filters.partners;

const initialViewDataSelector = createSelector(
    getDenormalizedVariants,
    variants => {
        const partners: Record<string, ITDPartner> = {};

        for (let i = 0; i < variants.length; i++) {
            const {partner} = variants[i].price;
            partners[partner.code] = partner;
        }

        return {partners, disabledPartners: {}};
    },
);

const validValueSelector = createSelector(
    valueSelector,
    initialViewDataSelector,
    (value, viewData) =>
        value.filter(partnerCode => viewData.partners[partnerCode]),
);

const filteredSelector = createSelector(
    validValueSelector,
    getDenormalizedVariants,
    aviaFilterBy.partner,
);

const isActiveSelector = createSelector(
    validValueSelector,
    value => value.length > 0,
);

const selectedCountSelector = createSelector(
    validValueSelector,
    value => value.length,
);

export const aviaPartnersFilterSelector = {
    key: 'partners',
    isActive: isActiveSelector,
    selectedCount: selectedCountSelector,
    filtered: filteredSelector,
    initialViewData: initialViewDataSelector,
    value: validValueSelector,
};
