import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';
import {IPartnersFilterViewData} from 'selectors/avia/search/filters/partnersFilter/index';

export const aviaUpdatePartnersViewData = (
    variants: IResultAviaVariant[],
    viewData: IPartnersFilterViewData,
    filteredByOthers: Record<string, boolean>,
) => {
    const {disabledPartners} = viewData;

    for (let i = 0; i < variants.length; i++) {
        const variant = variants[i];
        const {partner} = variant.price;

        if (disabledPartners[partner.code] !== false) {
            disabledPartners[partner.code] = Boolean(
                filteredByOthers[variant.tag],
            );
        }
    }

    return viewData;
};
