import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import {getDenormalizedVariants} from 'selectors/avia/search/getDenormalizedVariants';

import {aviaFilterBy} from 'projects/avia/lib/search/filters/filterVariants';
import IPrice from 'utilities/currency/PriceInterface';

export interface IPlusPointsFilterViewData {
    price: IPrice | null;
}

const valueSelector = (state: StoreInterface) =>
    state.avia.aviaSearch.results.filters.plusPoints;

const filteredSelector = createSelector(
    valueSelector,
    getDenormalizedVariants,
    aviaFilterBy.plusPoints,
);

const isActiveSelector = createSelector(valueSelector, value => value.enabled);

export const aviaPlusPointsFilterSelector = {
    key: 'plusPoints',
    isActive: isActiveSelector,
    filtered: filteredSelector,
    value: valueSelector,
};
