import {isNotNullable} from 'types/utilities';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {PriceComparator} from 'utilities/currency/compare';

import {IPlusPointsFilterViewData} from './index';

export function aviaUpdatePlusPointsViewData(
    variants: IResultAviaVariant[],
    filteredByOthers: Record<string, boolean>,
    {min}: PriceComparator,
): IPlusPointsFilterViewData {
    let price = null;

    for (let i = 0; i < variants.length; i++) {
        const variant = variants[i];
        const isFilteredByOthers = Boolean(filteredByOthers[variant.tag]);

        if (!isFilteredByOthers && isNotNullable(variant.price.plusPoints)) {
            price = price
                ? min(variant.price.tariff, price)
                : variant.price.tariff;
        }
    }

    return {
        price,
    };
}
