import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import {getDenormalizedVariants} from 'selectors/avia/search/getDenormalizedVariants';
import {priceComparatorSelector} from 'selectors/common/currenciesSelector';

import IPrice from 'utilities/currency/PriceInterface';
import {aviaFilterBy} from 'projects/avia/lib/search/filters/filterVariants';

export interface IPriceFilterViewData {
    minPrice?: IPrice;
    maxPrice?: IPrice;
}

const valueSelector = (state: StoreInterface) =>
    state.avia.aviaSearch.results.filters.price;

const filteredSelector = createSelector(
    valueSelector,
    getDenormalizedVariants,
    priceComparatorSelector,
    aviaFilterBy.price,
);

const isActiveSelector = createSelector(
    valueSelector,
    // eslint-disable-next-line no-eq-null
    value => value.value != null,
);

export const aviaPriceFilterSelector = {
    key: 'price',
    isActive: isActiveSelector,
    filtered: filteredSelector,
    value: valueSelector,
};
