import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';
import {IPriceFilterViewData} from 'selectors/avia/search/filters/priceFilter/index';

import {PriceComparator} from 'utilities/currency/compare';

export function aviaUpdatePriceViewData(
    variants: IResultAviaVariant[],
    filteredByOthers: Record<string, boolean>,
    {min}: PriceComparator,
): IPriceFilterViewData {
    let minPrice, maxPrice;

    for (let i = 0; i < variants.length; i++) {
        const variant = variants[i];

        if (!filteredByOthers[variant.tag]) {
            const price = variant.price.tariff;

            minPrice = minPrice ? min(price, minPrice) : price;
            /*
            т.к. фильтр по цене в данный момент не используется,
            то нам достаточно информации по минимальной цене

            maxPrice = maxPrice
                ? priceComparator.max(price, maxPrice)
                : price;
             */
        }
    }

    return {
        minPrice,
        maxPrice,
    };
}
