import {EAviaSearchTransferFilter} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {createFlags, join} from 'utilities/flags/flags';

import {TransferFilterViewData} from './index';
import {getMinMaxTransfersDurationForRoute} from './getMinMaxTransfersDurationForRoute';

export function getInitialViewData(
    variants: IResultAviaVariant[],
): TransferFilterViewData {
    let minDuration = Infinity;
    let maxDuration = 0;
    let hasTransfers = false;
    for (const variant of variants) {
        const durations = getMinMaxTransfersDurationForRoute(variant.route);
        if (durations) {
            maxDuration = Math.max(durations.max, maxDuration);
            minDuration = Math.min(durations.min, minDuration);
            hasTransfers = true;
        }
    }

    return {
        disabled: join<EAviaSearchTransferFilter>([
            createFlags(EAviaSearchTransferFilter.EXCLUDE_NIGHTLY),
            createFlags(EAviaSearchTransferFilter.NO_TRANSFERS),
            createFlags(EAviaSearchTransferFilter.NO_AIRPORT_CHANGE),
            createFlags(EAviaSearchTransferFilter.ONE_CHANGE),
        ]),
        minDuration,
        maxDuration,
        hasTransfers,
    };
}
