import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';

export interface IMinMaxTransferDuration {
    min: number;
    max: number;
}

export function getMinMaxTransfersDurationForRoute(
    route: IResultAviaFlight[][],
): IMinMaxTransferDuration | null {
    const times = route
        .map(getMinMaxTransfersDuration)
        .filter(Boolean) as IMinMaxTransferDuration[];

    if (times.length === 0) {
        return null;
    }

    return times.reduce(
        (acc, {min, max}) => ({
            min: Math.min(min, acc.min),
            max: Math.max(max, acc.max),
        }),
        {min: Infinity, max: 0},
    );
}

function getMinMaxTransfersDuration(
    segment: IResultAviaFlight[],
): IMinMaxTransferDuration | null {
    if (segment.length < 2) {
        return null;
    }
    let minDuration = Infinity;
    let maxDuration = 0;
    for (let i = 0; i < segment.length - 1; i++) {
        const arrivalFlight = segment[i];
        const departureFlight = segment[i + 1];
        const duration =
            departureFlight.departureTime - arrivalFlight.arrivalTime;
        minDuration = Math.min(duration, minDuration);
        maxDuration = Math.max(duration, maxDuration);
    }
    return {
        min: minDuration,
        max: maxDuration,
    };
}
