import {
    EAviaSearchTransferFilter,
    IAviaSearchTransferFilter,
} from 'reducers/avia/search/results/filters/reducer';

import {TransferFilterViewData} from 'selectors/avia/search/filters/transferFilter/index';

import {createFlags, join} from 'utilities/flags/flags';
import {tupple} from 'projects/avia/lib/tupple';

const ALL_VALUES = join<EAviaSearchTransferFilter>([
    createFlags(EAviaSearchTransferFilter.EXCLUDE_NIGHTLY),
    createFlags(EAviaSearchTransferFilter.NO_TRANSFERS),
    createFlags(EAviaSearchTransferFilter.NO_AIRPORT_CHANGE),
    createFlags(EAviaSearchTransferFilter.ONE_CHANGE),
]);

export const validateValue = (
    {value, range}: IAviaSearchTransferFilter,
    {minDuration: min, maxDuration: max}: TransferFilterViewData,
) => {
    let validValue = value;
    if (validValue < 0 || validValue > ALL_VALUES) {
        validValue = createFlags(0);
    }
    let validRange: [number, number] | null = range;
    if (validRange) {
        if (validRange[0] > validRange[1]) {
            // eslint-disable-next-line no-param-reassign
            validRange = [validRange[1], validRange[0]];
        }
        validRange = tupple(
            validRange[0] ? Math.max(validRange[0], min) : min,
            validRange[1] ? Math.min(validRange[1], max) : max,
        );
    }
    return {
        value: validValue,
        range: validRange,
    };
};
