import {cloneDeep} from 'lodash';
import {createSelector} from 'reselect';

import {priceComparatorSelector} from 'selectors/common/currenciesSelector';
import {aviaTimeFilterSelector} from 'selectors/avia/search/filters/timeFilter';
import {aviaCompanyFilterSelector} from 'selectors/avia/search/filters/companyFilter';
import {getDenormalizedVariants} from 'selectors/avia/search/getDenormalizedVariants';
import {aviaTransferFilterSelector} from 'selectors/avia/search/filters/transferFilter';
import {aviaPartnersFilterSelector} from 'selectors/avia/search/filters/partnersFilter';
import {aviaAirportsFilterSelector} from 'selectors/avia/search/filters/airportsFilter';
import {aviaFilteredByOthersSelector} from 'selectors/avia/search/filters/filteredByOther';
import {aviaUpdateTimeViewData} from 'selectors/avia/search/filters/timeFilter/updateViewData';
import {aviaUpdatePriceViewData} from 'selectors/avia/search/filters/priceFilter/updateViewData';
import {aviaUpdateCompanyViewData} from 'selectors/avia/search/filters/companyFilter/updateViewData';
import {aviaUpdateBaggageViewData} from 'selectors/avia/search/filters/baggageFilter/updateViewData';
import {aviaUpdatePartnersViewData} from 'selectors/avia/search/filters/partnersFilter/updateViewData';
import {aviaUpdatePlusPointsViewData} from 'selectors/avia/search/filters/plusPointsFilter/updateViewData';
import {aviaUpdateAirportsViewData} from 'selectors/avia/search/filters/airportsFilter/updateViewData';
import {
    aviaUpdateNoTransferMinPrice,
    aviaUpdateTransferViewData,
} from 'selectors/avia/search/filters/transferFilter/updateViewData';

export const aviaFiltersViewDataSelector = {
    airports: createSelector(
        getDenormalizedVariants,
        aviaAirportsFilterSelector.value,
        aviaAirportsFilterSelector.initialViewData,
        aviaAirportsFilterSelector.filtered,
        aviaFilteredByOthersSelector.airports,
        (variants, value, initialViewData, filtered, filteredByOthers) =>
            aviaUpdateAirportsViewData(
                variants,
                filtered,
                filteredByOthers,
                value,
                cloneDeep(initialViewData),
            ),
    ),
    baggage: createSelector(
        getDenormalizedVariants,
        aviaFilteredByOthersSelector.baggage,
        priceComparatorSelector,
        aviaUpdateBaggageViewData,
    ),
    company: createSelector(
        getDenormalizedVariants,
        aviaCompanyFilterSelector.value,
        aviaCompanyFilterSelector.initialViewData,
        aviaFilteredByOthersSelector.company,
        priceComparatorSelector,
        (variants, value, initialViewData, filteredByOthers, priceComparator) =>
            aviaUpdateCompanyViewData(
                variants,
                value,
                cloneDeep(initialViewData),
                filteredByOthers,
                priceComparator,
            ),
    ),
    partners: createSelector(
        getDenormalizedVariants,
        aviaPartnersFilterSelector.initialViewData,
        aviaFilteredByOthersSelector.partners,
        (variants, initialViewData, filteredByOthers) =>
            aviaUpdatePartnersViewData(
                variants,
                cloneDeep(initialViewData),
                filteredByOthers,
            ),
    ),
    plusPoints: createSelector(
        getDenormalizedVariants,
        aviaFilteredByOthersSelector.plusPoints,
        priceComparatorSelector,
        aviaUpdatePlusPointsViewData,
    ),
    price: createSelector(
        getDenormalizedVariants,
        aviaFilteredByOthersSelector.price,
        priceComparatorSelector,
        aviaUpdatePriceViewData,
    ),
    time: createSelector(
        getDenormalizedVariants,
        aviaTimeFilterSelector.value,
        aviaTimeFilterSelector.initialViewData,
        aviaTimeFilterSelector.filtered,
        aviaFilteredByOthersSelector.time,
        (variants, value, initialViewData, filtered, filteredByOthers) =>
            aviaUpdateTimeViewData(
                variants,
                filteredByOthers,
                cloneDeep(initialViewData),
                filtered,
                value,
            ),
    ),
    transfer: createSelector(
        getDenormalizedVariants,
        aviaTransferFilterSelector.value,
        aviaTransferFilterSelector.initialViewData,
        aviaTransferFilterSelector.filtered,
        aviaFilteredByOthersSelector.transfer,
        (variants, value, initialViewData, filtered, filteredByOthers) =>
            aviaUpdateTransferViewData(
                variants,
                value,
                cloneDeep(initialViewData),
                filtered,
                filteredByOthers,
            ),
    ),
    noTransferMinPrice: createSelector(
        getDenormalizedVariants,
        aviaTransferFilterSelector.filtered,
        aviaFilteredByOthersSelector.transfer,
        priceComparatorSelector,
        aviaUpdateNoTransferMinPrice,
    ),
};
