import {createSelector} from 'reselect';

import {aviaInterestVariantsSelector} from 'selectors/avia/search/interest';
import {sortVariantsGroups} from 'selectors/avia/search/sorting/sortVariantsGroup';
import {getAviaSearchSorting} from 'selectors/avia/search/aviaSearchResultsSelector';
import {getFilteredGroupedVariants} from 'selectors/avia/search/getFilteredGroupedVariants';
import {
    getAviaSearchVariantsView,
    IAviaSearchVariantsView,
} from 'selectors/avia/utils/getAviaSearchVariantsView';
import {priceComparatorSelector} from 'selectors/common/currenciesSelector';

export const getAviaSearchVariantsViewSelector = createSelector(
    getFilteredGroupedVariants,
    getAviaSearchSorting,
    aviaInterestVariantsSelector,
    priceComparatorSelector,
    (
        groupedVariants,
        sorting,
        interest,
        priceComparator,
    ): IAviaSearchVariantsView => {
        const sortedGroups = sortVariantsGroups(
            groupedVariants,
            sorting,
            priceComparator,
        );

        return getAviaSearchVariantsView(
            sortedGroups,
            sorting,
            interest,
            priceComparator,
        );
    },
);
