import {createSelector} from 'reselect';
import {values} from 'lodash';

import {INormalizedFare} from 'reducers/avia/utils/ticketDaemon/normalizeTDVariants';
import {INormalizedTDReference} from 'reducers/avia/utils/ticketDaemon/normalizeTDReference';

import {
    createResultAviaVariants,
    IResultAviaVariant,
} from 'selectors/avia/utils/denormalization/variant';
import {getAviaSearchVariantsMap} from 'selectors/avia/search/aviaSearchResultsSelector';

import {logWarning} from 'utilities/logger/logWarning';

export const getDenormalizedVariants = createSelector(
    getAviaSearchVariantsMap,
    values,
);

export function processNormalizedVariants(
    normalizedVariantsMap: Record<string, INormalizedFare>,
    reference: INormalizedTDReference,
): IResultAviaVariant[] {
    const normalizedVariants = values(normalizedVariantsMap);
    const variants: IResultAviaVariant[] = [];
    const brokenKeys: string[] = [];

    for (const normalizedVariant of normalizedVariants) {
        const denormalizedVariants = createResultAviaVariants(
            normalizedVariant,
            reference,
        );

        if (denormalizedVariants) {
            for (const variant of denormalizedVariants) {
                variants.push(variant);
            }
        } else if (typeof window !== 'undefined') {
            brokenKeys.push(normalizedVariant.key);
        }
    }

    if (brokenKeys.length && typeof window !== 'undefined') {
        logWarning({
            message: '[YATRAVEL][AVIA] Не удалось обработать вариант',
            additional: {
                keys: brokenKeys.join(),
            },
        });
    }

    return variants;
}
