import {createSelector} from 'reselect';

import {getDenormalizedVariants} from 'selectors/avia/search/getDenormalizedVariants';
import {aviaAirportsFilterSelector} from 'selectors/avia/search/filters/airportsFilter';
import {aviaBaggageFilterSelector} from 'selectors/avia/search/filters/baggageFilter';
import {aviaCompanyFilterSelector} from 'selectors/avia/search/filters/companyFilter';
import {aviaPartnersFilterSelector} from 'selectors/avia/search/filters/partnersFilter';
import {aviaPriceFilterSelector} from 'selectors/avia/search/filters/priceFilter';
import {aviaTimeFilterSelector} from 'selectors/avia/search/filters/timeFilter';
import {aviaTransferFilterSelector} from 'selectors/avia/search/filters/transferFilter';
import {aviaPlusPointsFilterSelector} from 'selectors/avia/search/filters/plusPointsFilter';

/**
 * Возвращает словарь {[VariantTag]: IResultAviaVariant} с вариантами,
 * которые нужно убрать из выдачи
 */
export const excludedVariantsSelector = createSelector(
    aviaAirportsFilterSelector.filtered,
    aviaBaggageFilterSelector.filtered,
    aviaCompanyFilterSelector.filtered,
    aviaPartnersFilterSelector.filtered,
    aviaPriceFilterSelector.filtered,
    aviaTimeFilterSelector.filtered,
    aviaTransferFilterSelector.filtered,
    aviaPlusPointsFilterSelector.filtered,
    (...filtered) => Object.assign({}, ...filtered),
);

/**
 * Возваращает список отфильтрованных вариантов
 */
export const getFilteredVariants = createSelector(
    getDenormalizedVariants,
    excludedVariantsSelector,
    (variants, filtered) => variants.filter(variant => !filtered[variant.tag]),
);
