import {createSelector} from 'reselect';

import {getAllGroupedVariants} from 'selectors/avia/search/getAllGroupedVariants';
import {getFilteredGroupedVariants} from 'selectors/avia/search/getFilteredGroupedVariants';

export const getGroupedVariantsInfo = createSelector(
    getAllGroupedVariants,
    getFilteredGroupedVariants,
    (all, filtered) => ({
        all: all.length,
        shown: filtered.length,
        hidden: all.length - filtered.length,
    }),
);
