import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';
import {IAviaSearchResultsSorting} from 'reducers/avia/search/results/reducer';
import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import comfySelector from 'selectors/avia/search/interest/comfy';
import popularSelector from 'selectors/avia/search/interest/popular';
import cheapestSelector from 'selectors/avia/search/interest/cheapest';
import fromCompanySelector from 'selectors/avia/search/interest/fromCompany';
import {boyInterestVariantsSelector} from 'selectors/avia/search/interest/boyInterestVariants';
import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';
import {getAviaSearchSorting} from 'selectors/avia/search/aviaSearchResultsSelector';

export interface IAviaInterestVariants {
    comfy: IAviaVariantGroup[];
    popular: IAviaVariantGroup[];
    cheapest: IAviaVariantGroup[];
    fromCompany: IAviaVariantGroup[];
    boy: IAviaVariantGroup[];
}

const interestStub: IAviaInterestVariants = {
    comfy: [],
    popular: [],
    cheapest: [],
    fromCompany: [],
    boy: [],
};

// То что некоторые интересные варианты передаются полностью,
// а из других берётся лишь первый элемент обусловлено логикой авиа
const interestSelector = createSelector(
    comfySelector,
    popularSelector,
    cheapestSelector,
    fromCompanySelector,
    boyInterestVariantsSelector,
    (comfy, popular, cheapest, fromCompany, boy): IAviaInterestVariants => ({
        comfy: comfy.length ? [comfy[0]] : [],
        popular,
        cheapest,
        fromCompany: fromCompany.length ? [fromCompany[0]] : [],
        boy,
    }),
);

export const aviaInterestVariantsSelector = createSelector(
    (state: StoreInterface) => state,
    getAviaSearchSorting,
    (state: StoreInterface, sorting: IAviaSearchResultsSorting) => {
        return sorting.type === EAviaResultsSortType.INTEREST
            ? interestSelector(state)
            : interestStub;
    },
);
