import {createSelector} from 'reselect';

import {getFilteredGroupedVariants} from './getFilteredGroupedVariants';

export const getMinPrice = createSelector(
    getFilteredGroupedVariants,
    variantGroups => {
        let minPrice: number | null = null;

        variantGroups.forEach(variant => {
            const variantPrice =
                variant.cheapestVariantsByTariff.cheapest.price.tariff.value;

            if (!minPrice || minPrice > variantPrice) minPrice = variantPrice;
        });

        return minPrice;
    },
);
