import {groupBy} from 'lodash';
import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

interface IFlightsDictionary {
    [index: string]: string[];
}

export interface IAviaPopularFlights {
    hasForward: boolean;
    hasBackward: boolean;
    forward: IFlightsDictionary;
    backward: IFlightsDictionary;
}

export const popularFlightsSelector = createSelector(
    (state: StoreInterface) =>
        state.avia.aviaSearch.results.popularFlights.data,
    ({forward, backward}): IAviaPopularFlights => ({
        hasForward: Boolean(forward.length),
        hasBackward: Boolean(backward.length),
        forward: groupBy(forward),
        backward: groupBy(backward),
    }),
);
